<?php

namespace FacturaScripts\Plugins\Partes\Controller;

use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Core\Lib\ExtendedController\ListController;
use FacturaScripts\Dinamic\Model\TareaProyecto;

class ListOIOperarioTarea extends ListController
{
    public function getPageData(): array
    {
        $data = parent::getPageData();
//        $data["title"] = "Horas";
        $data["menu"] = "";
//        $data["icon"] = "";
        return $data;
    }

    protected function createViews()
    {
        $this->createViewsOIOperarioTarea();
    }

    protected function createViewsOIOperarioTarea(string $viewName = "ListOIOperarioTarea")
    {
        $this->addView($viewName, 'OIOperarioTarea', 'Horas')
            ->setSettings('btnNew', false)
            ->setSettings('btnDelete', false);

        // Esto es un ejemplo ... debe de cambiarlo según los nombres de campos del modelo
        // $this->addOrderBy($viewName, ["id"], "id", 2);
        // $this->addOrderBy($viewName, ["name"], "name");

        // Esto es un ejemplo ... debe de cambiarlo según los nombres de campos del modelo
        // $this->addSearchFields($viewName, ["id", "name"]);
    }

    protected function loadData($viewName, $view)
    {
        $where = $this->permissions->onlyOwnerData ? $this->getOwnerFilter($view->model) : [];
        $where[] = new DataBaseWhere('horas', 0, '>');
        $view->loadData('', $where);

        if ($viewName === 'ListOIOperarioTarea') {
            foreach ($view->cursor as $model) {
                $tarea = new TareaProyecto();
                if ($tarea->loadFromCode($model->idtarea)) {
                    $model->idproyecto = $tarea->idproyecto;
                    $model->responsable = $tarea->responsable;
                }
            }
        }
    }
}
