<?php

namespace FacturaScripts\Plugins\Partes\Controller;

use FacturaScripts\Core\Lib\ExtendedController\EditController;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;

class EditOiVehiculo extends EditController
{
    public function getModelClassName(): string
    {
        return "OiVehiculo";
    }

    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data["title"] = "Flota";
        $data["icon"] = "fas fa-car";
        return $data;
	}

    protected function createViews()
    {
        parent::createViews();
        $this->setTabsPosition("left-bottom");
        $this->createViewsHoras();
    }

    protected function createViewsHoras(string $viewName = "EditOIVehiculoOrden")
    {
        $this->addListView($viewName, "OIVehiculoOrden", "Partes");
	}

    protected function loadData($viewName, $view)
    {
		if ($viewName == 'EditOIVehiculoOrden') {
			$idvehiculo = $this->request->get('code');
			
		    $Where = [new DataBaseWhere('idvehiculo', $idvehiculo)];
		    $view->loadData('', $Where);
		    return;
	    }

	    parent::loadData($viewName, $view);
	}

}
