<?php

namespace FacturaScripts\Plugins\Partes\Controller;

use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Core\Lib\ExtendedController\EditController;
use FacturaScripts\Dinamic\Model\Proyecto;
use FacturaScripts\Dinamic\Model\TareaProyecto;

class EditOIOperarioTarea extends EditController
{
    public function getModelClassName(): string
    {
        return "OIOperarioTarea";
    }

    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data["title"] = "OIOperarioTarea";
        $data["icon"] = "fas fa-search";
        return $data;
    }

    protected function createViews(): void
    {
        parent::createViews();
        $mainView = $this->getMainViewName();
        $this->setSettings($mainView, 'btnDelete', false);
        $this->setTabsPosition("left-bottom");
        $this->createViewsList();
    }

    protected function createViewsList()
    {
        $this->addListView("ListOiFichajes", "OIFichajes", "Fichajes", "fas fa-user-clock");
        $this->setSettings('ListOiFichajes', 'btnDelete', false);
    }

    protected function loadData($viewName, $view)
    {
        if ($viewName === 'ListOiFichajes') {
            $model = $this->getModel();
            $where = [
                new DataBaseWhere('nick', $model->nick),
                new DataBaseWhere('idtarea', $model->idtarea),
            ];
            $view->loadData('', $where);
            return;
        }

        parent::loadData($viewName, $view);

        if ($viewName === 'EditOIOperarioTarea') {
            $model = $this->getModel();
            $tarea = new TareaProyecto();
            if ($tarea->loadFromCode($model->idtarea)) {
                $model->nombretarea = $tarea->nombre;
                $proyecto = new Proyecto();
                if ($proyecto->loadFromCode($tarea->idproyecto)) {
                    $model->nombreparte = $proyecto->nombre;
                }
            }
        }
    }

}
