<?php

namespace FacturaScripts\Plugins\Partes\Controller;

use FacturaScripts\Core\Base\Controller;
use FacturaScripts\Dinamic\Model\CodeModel;
use FacturaScripts\Dinamic\Model\FaseTarea;
use FacturaScripts\Dinamic\Model\Proyecto;
use FacturaScripts\Dinamic\Model\TareaProyecto;
use FacturaScripts\Dinamic\Model\OITareaProyecto;

class CopyProyecto extends Controller
{
    public $codeModel;
    public $fases;

    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data["menu"] = "";
        $data["title"] = "CopyProyecto";
        $data["icon"] = "fas fa-file";
        return $data;
    }


    public function privateCore(&$response, $user, $permissions)
    {
        parent::privateCore($response, $user, $permissions);
        $this->codeModel = new CodeModel();

        $fase = new FaseTarea();
        $this->fases = $fase->all([], ['nombre' => 'ASC']);

        $name = $this->request->request->get('name');

        if ($name) {
            $code = $this->request->get('code');
            $this->copyProyecto($code, $name);
        }
    }

    private function copyProyecto($code, $name)
    {
        $proyecto = new Proyecto();
        $proyecto->loadFromCode($code);
        $newProyecto = clone $proyecto;
        $newProyecto->idproyecto = null;
        $newProyecto->nombre = $name;
        $newProyecto->plantilla_proyecto = false;
        $newProyecto->codcliente = $this->request->request->get('codcliente');
        $newProyecto->save();

        if ($this->request->request->get('copiarTarea')) {
            $this->copyTareas($proyecto, $newProyecto);
        }

    }

    private function copyTareas(Proyecto $proyecto, Proyecto $newProyecto)
    {
    	$tareas = (new OITareaProyecto)->getTareas($proyecto->idproyecto);
        foreach ($tareas as $tarea) {
            $newTarea = clone $tarea;
            $newTarea->idtarea = null;
	    if (!$this->request->request->get('copiarResponsable')) {
		    $newTarea->responsable = null;
	    }
            $newTarea->idproyecto = $newProyecto->idproyecto;
            $newTarea->save();
	    if ($this->request->request->get('copiarSubTareas')) {
		    $this->copySubTareas($tarea, $newTarea);
	    }
	    if ($this->request->request->get('copiarOperarios')) {
		    $this->copyOperarios($tarea, $newTarea);
	    }
        }
    }

	private function copyOperarios($tarea, $newTarea)
	{
		$operarios = $tarea->getOperarios();
		foreach($operarios as $operario){
			$newOperario = clone $operario;
			$newOperario->id = null;
			$newOperario->idtarea = $newTarea->idtarea;
			$newOperario->save();
		}
	}

    private function copySubTareas($tarea, $newTarea)
    {
    	$subTasks = $tarea->getSubTask();
	foreach($subTasks as $subTask){
            $newSubTask = clone $subTask;
            $newSubTask->idtarea = null;
	    $newSubTask->idtareapadre = $newTarea->idtarea;
	    $newSubTask->idproyecto = $newTarea->idproyecto;
            $newSubTask->save();
	}

    }

}
