<?php

namespace FacturaScripts\Plugins\Partes\Controller;

use FacturaScripts\Core\Lib\ExtendedController\PanelController;
use FacturaScripts\Core\Lib\ExtendedController\BaseView;

class AdminPartes extends PanelController
{
    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data['menu'] = 'admin';
        $data['title'] = 'Partes';
        $data['icon'] = 'fas fa-cog';
        return $data;
    }

    protected function createViews(): void
    {
        $this->setTemplate('EditSettings');
        $this->addEditView('ConfigPartes', 'Settings', 'general');
    }

    protected function loadData($viewName, $view): void
    {
        if ($viewName === 'ConfigPartes' && $view instanceof BaseView) {
            $view->loadData('partes');
            $view->model->name = 'partes';
        }
    }
}
