<?php

namespace FacturaScripts\Plugins\NextCloud\Service;

use FacturaScripts\Dinamic\Model\User;

/**
 * Helper to build NextcloudService instances using user credentials.
 */
class NextcloudConnectionFactory
{
    /**
     * Returns the configured connection parameters for the given user.
     */
    public static function getCredentials(?User $user = null): array
    {
        if (null === $user) {
            return ['', '', ''];
        }

        $url = $user->nextcloud_url ?? '';
        $username = $user->nextcloud_user ?? '';
        $token = $user->nextcloud_token ?? '';

        return [$url, $username, $token];
    }

    /**
     * Builds a NextcloudService for the given user or returns null when credentials are incomplete.
     */
    public static function buildForUser(?User $user = null): ?NextcloudService
    {
        [$url, $username, $token] = self::getCredentials($user);
        if (empty($url) || empty($username) || empty($token)) {
            return null;
        }

        return new NextcloudService($url, $username, $token);
    }

    /**
     * Builds a NextcloudService using the credentials of the given user nick.
     */
    public static function buildForNick(?string $nick): ?NextcloudService
    {
        if (empty($nick)) {
            return null;
        }

        $user = new User();
        if (false === $user->loadFromCode($nick)) {
            return null;
        }

        return self::buildForUser($user);
    }
}
