<?php

namespace FacturaScripts\Plugins\NextCloud\Helper;

use FacturaScripts\Dinamic\Model\User;
use FacturaScripts\Plugins\NextCloud\Service\NextcloudConnectionFactory;

class NextcloudFolderHelper
{
    /**
     * Returns a simple list of folders available at the root of the Nextcloud account.
     *
     * @return array<string, string>
     */
    public static function listRootFolders(?User $user = null): array
    {
        $service = NextcloudConnectionFactory::buildForUser($user);
        if (null === $service) {
            return [];
        }

        $folders = ['/' => '/'];
        foreach ($service->listFiles('/') as $item) {
            if ($item['isDir']) {
                $name = '/' . ltrim($item['name'], '/');
                $folders[$name] = $name;
            }
        }

        return $folders;
    }
}
