<?php

namespace FacturaScripts\Plugins\NextCloud\Helper;

use FacturaScripts\Plugins\NextCloud\Service\NextcloudService;

class NextcloudAttachmentHelper
{
    public static function buildRemotePath(string $folder, string $fileName, int $fallbackId): string
    {
        $name = trim($fileName);
        if ($name === '') {
            $name = 'archivo-' . $fallbackId;
        }

        return rtrim($folder, '/') . '/' . $name;
    }

    public static function ensureRemotePath(NextcloudService $service, string $folder): void
    {
        $cleanFolder = trim($folder, '/');
        if ($cleanFolder === '') {
            return;
        }

        $current = '';
        foreach (explode('/', $cleanFolder) as $segment) {
            if ($segment === '') {
                continue;
            }

            $current .= '/' . $segment;
            $service->makeDir($current);
        }
    }

    public static function resolveFolder(string $modelName, $code): string
    {
        switch ($modelName) {
            case 'Cliente':
                return self::loadFolderFromModel('Cliente', $code, 'codcliente');

            case 'Proveedor':
                return self::loadFolderFromModel('Proveedor', $code, 'codproveedor');

            case 'Proyecto':
                return self::loadFolderFromModel('Proyecto', $code, 'idproyecto');

            default:
                return '';
        }
    }

    private static function loadFolderFromModel(string $modelName, $code, string $defaultField): string
    {
        $className = '\\FacturaScripts\\Dinamic\\Model\\' . $modelName;
        if (false === class_exists($className)) {
            return '';
        }

        $model = new $className();
        if (false === $model->loadFromCode($code)) {
            return '';
        }

        $folder = trim((string)($model->nextcloud_folder ?? ''));
        if ($folder !== '') {
            return '/' . ltrim($folder, '/');
        }

        $value = (string)($model->{$defaultField} ?? $code);
        $value = self::slugify($value);
        return '/' . strtolower($modelName) . '/' . $value;
    }

    private static function slugify(string $value): string
    {
        $clean = preg_replace('/[^A-Za-z0-9_\-]/', '-', $value);
        $clean = preg_replace('/-+/', '-', $clean ?? '');
        return trim($clean ?: $value, '-');
    }
}
