<?php

namespace FacturaScripts\Plugins\NextCloud\Extension\Model;

use Closure;
use FacturaScripts\Plugins\NextCloud\Helper\NextcloudAttachmentHelper;
use FacturaScripts\Plugins\NextCloud\Helper\NextcloudEntityFolderMoveHelper;

class Cliente
{
    /** @var array<int, string> */
    private $oldFolders = [];

    public function saveBefore(): Closure
    {
        $oldFolders =& $this->oldFolders;

        return function () use (&$oldFolders): bool {
            $objectId = spl_object_id($this);
            $oldFolders[$objectId] = '';

            if (!$this->exists()) {
                return true;
            }

            $prev = new static();
            if ($prev->loadFromCode($this->primaryColumnValue())) {
                $oldFolders[$objectId] = trim((string)($prev->nextcloud_folder ?? ''));
            }

            return true;
        };
    }

    public function save(): Closure
    {
        $oldFolders =& $this->oldFolders;

        return function () use (&$oldFolders): bool {
            $objectId = spl_object_id($this);
            if (!array_key_exists($objectId, $oldFolders)) {
                return true;
            }

            $old = $oldFolders[$objectId];
            unset($oldFolders[$objectId]);

            $new = trim((string)($this->nextcloud_folder ?? ''));
            if (NextcloudEntityFolderMoveHelper::normalizeFolderValue($old) === NextcloudEntityFolderMoveHelper::normalizeFolderValue($new)) {
                return true;
            }

            $code = $this->primaryColumnValue();
            if (empty($code)) {
                return true;
            }

            $targetFolder = NextcloudAttachmentHelper::resolveFolder($this->modelClassName(), $code);
            NextcloudEntityFolderMoveHelper::moveAttachedFiles($this->modelClassName(), $code, $targetFolder);
            return true;
        };
    }
}
