<?php

namespace FacturaScripts\Plugins\NextCloud\Extension\Controller;

use Closure;
use FacturaScripts\Dinamic\Lib\AssetManager;
use FacturaScripts\Plugins\NextCloud\Helper\NextcloudFolderHelper;

class EditProyecto
{
    public function loadData(): Closure
    {
        return function ($viewName, $view) {
            AssetManager::addJs(FS_ROUTE . '/Plugins/NextCloud/Assets/JS/nextcloud-folder-selector.js');

            $column = $view->columnForName('nextcloud-folder');
            if (null === $column || $column->widget->getType() !== 'select') {
                return;
            }

            $folders = NextcloudFolderHelper::listRootFolders($this->user);
            $current = trim((string)($view->model->nextcloud_folder ?? ''));
            if ($current !== '' && !isset($folders[$current])) {
                $folders[$current] = $current;
            }
            $column->widget->setValuesFromArray($folders, false, true);
        };
    }
}
