<?php

namespace FacturaScripts\Plugins\NextCloud\Controller;

use FacturaScripts\Core\Base\Controller;
use FacturaScripts\Core\Tools;
use FacturaScripts\Plugins\NextCloud\Service\NextcloudConnectionFactory;

class NextcloudFolders extends Controller
{
    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data['title'] = 'nextcloud';
        $data['icon'] = 'fas fa-cloud';
        $data['menu'] = 'Cloud';
        $data['showonmenu'] = false;
        return $data;
    }

    public function privateCore(&$response, $user, $permissions)
    {
        parent::privateCore($response, $user, $permissions);

        $service = NextcloudConnectionFactory::buildForUser($user);
        if (null === $service) {
            Tools::log()->warning('nextcloud-missing-credentials');
            $this->setErrorResponse($response, 'missing-credentials', 400);
            return;
        }

        $path = $this->normalizePath((string)$this->request->get('path', '/'));
        $folders = [];
        foreach ($service->listFiles($path) as $item) {
            if (!empty($item['isDir'])) {
                $folders[] = [
                    'name' => $item['name'],
                    'path' => $this->joinPath($path, $item['name']),
                ];
            }
        }

        $response->headers->set('Content-Type', 'application/json');
        $response->setContent(json_encode([
            'path'    => $path,
            'folders' => $folders,
        ]));
        $this->setTemplate(false);
    }

    private function normalizePath(string $path): string
    {
        $clean = '/' . ltrim($path, '/');
        $clean = preg_replace('#/+#', '/', $clean ?? '/');
        return rtrim($clean, '/') ?: '/';
    }

    private function joinPath(string $base, string $name): string
    {
        $base = rtrim($base, '/');
        return ($base === '' ? '' : $base) . '/' . ltrim($name, '/');
    }

    private function setErrorResponse(&$response, string $message, int $statusCode): void
    {
        $response->setStatusCode($statusCode);
        $response->headers->set('Content-Type', 'application/json');
        $response->setContent(json_encode(['error' => $message]));
        $this->setTemplate(false);
    }
}
