<?php declare(strict_types=1);

namespace FacturaScripts\Plugins\NextCloud;

use FacturaScripts\Core\Base\InitClass;

/**
 * Los plugins pueden contener un archivo Init.php en el que se definen procesos a ejecutar
 * cada vez que carga FacturaScripts o cuando se instala o actualiza el plugin.
 *
 * https://facturascripts.com/publicaciones/el-archivo-init-php-307
 */
class Init extends InitClass
{
    public function init(): void
    {
        // se ejecuta cada vez que carga FacturaScripts (si este plugin está activado).
        $this->loadExtension(new Extension\Model\AttachedFile());
        $this->loadExtension(new Extension\Model\AttachedFileRelation());
        $this->loadExtension(new Extension\Model\Cliente());
        $this->loadExtension(new Extension\Model\Proveedor());
        $this->loadExtension(new Extension\Model\Proyecto());
        $this->loadExtension(new Extension\Controller\EditCliente());
        $this->loadExtension(new Extension\Controller\EditProveedor());
        $this->loadExtension(new Extension\Controller\EditProyecto());
        $this->loadExtension(new Extension\Controller\EditSettings());
    }

    public function update(): void
    {
        // se ejecuta cada vez que se instala o actualiza el plugin
    }

    public function uninstall(): void
    {
        // se ejecuta cada vez que se desinstale el plugin. Primero desinstala y luego ejecuta el uninstall.
    }
}
