<?php

namespace FacturaScripts\Plugins\NextCloud\Extension\Model;

use Closure;
use FacturaScripts\Core\Tools;
use FacturaScripts\Plugins\NextCloud\Helper\NextcloudAttachmentHelper;
use FacturaScripts\Plugins\NextCloud\Service\NextcloudConnectionFactory;

class AttachedFileRelation
{
    public function save(): Closure
    {
        return function (): bool {
            if (empty($this->idfile) || empty($this->model)) {
                return true;
            }

            $file = $this->getFile();
            if (empty($file->idfile) || !empty($file->nextcloud_path)) {
                return true;
            }

            $code = empty($this->modelcode) ? $this->modelid : $this->modelcode;
            $folder = NextcloudAttachmentHelper::resolveFolder($this->model, $code);
            if (empty($folder)) {
                return true;
            }

            $service = NextcloudConnectionFactory::buildForNick($this->nick);
            if (null === $service) {
                Tools::log()->warning('nextcloud-missing-credentials');
                return true;
            }

            $remotePath = NextcloudAttachmentHelper::buildRemotePath($folder, $file->filename, (int)$file->idfile);
            NextcloudAttachmentHelper::ensureRemotePath($service, dirname($remotePath));

            $fullPath = $file->getFullPath();
            if (false === file_exists($fullPath)) {
                Tools::log()->warning('file-not-found', ['%fileName%' => $fullPath]);
                return true;
            }

            $content = file_get_contents($fullPath);
            if (false === $content) {
                Tools::log()->warning('fail');
                return true;
            }

            if (false === $service->putFile($remotePath, $content)) {
                Tools::log()->warning('fail');
                return true;
            }

            $file->nextcloud_path = $remotePath;
            $file->nextcloud_owner = $this->nick;
            $file->save();

            return true;
        };
    }
}
