<?php

namespace FacturaScripts\Plugins\NextCloud\Extension\Model;

use Closure;
use FacturaScripts\Plugins\NextCloud\Service\NextcloudConnectionFactory;

class AttachedFile
{
    public function delete(): Closure
    {
        return function (): bool {
            if (empty($this->nextcloud_path)) {
                return true;
            }

            $service = NextcloudConnectionFactory::buildForNick($this->nextcloud_owner);
            if (null === $service) {
                return true;
            }

            $service->deleteFile($this->nextcloud_path);
            return true;
        };
    }
}
