<?php
namespace FacturaScripts\Plugins\NextCloud\Extension\Controller;

use Closure;
use FacturaScripts\Core\Tools;
use FacturaScripts\Plugins\NextCloud\Service\NextcloudService;

class EditUser
{
    public function loadData(): Closure
    {
        return function ($viewName, $view) {
            $column = $view->columnForName('folder');
            if ($column && $column->widget->getType() === 'select') {
                $url = Tools::settings('nextcloud', 'url', '');
                $usernc = Tools::settings('nextcloud', 'user', '');
                $token = Tools::settings('nextcloud', 'token', '');

                if ($url && $usernc && $token) {
                    $service = new NextcloudService($url, $usernc, $token);
                    $items = $service->listFiles('/');
                    $folders = [];
                    foreach ($items as $item) {
                        if ($item['isDir']) {
                            $folders[] = $item['name'];
                        }
                    }

                    $column->widget->setValuesFromArray($folders, false, true);
                }
            }
        };
    }
}

