<?php

namespace FacturaScripts\Plugins\NextCloud\Extension\Controller;

use Closure;
use FacturaScripts\Core\Tools;
use FacturaScripts\Dinamic\Lib\AssetManager;
use FacturaScripts\Plugins\NextCloud\Helper\NextcloudFolderHelper;
use FacturaScripts\Plugins\NextCloud\Helper\NextcloudImportHelper;

class EditProveedor
{
    public function execPreviousAction(): Closure
    {
        return function ($action): bool {
            if (!in_array($action, ['nextcloud-import', 'nextcloud-preview'], true)) {
                return true;
            }

            if (false === $this->permissions->allowUpdate) {
                Tools::log()->warning('not-allowed-modify');
                return true;
            }

            $token = $this->request->request->get('multireqtoken', '');
            if (empty($token) || false === $this->multiRequestProtection->validate($token)) {
                Tools::log()->warning('invalid-request');
                return true;
            }

            if ($this->multiRequestProtection->tokenExist($token)) {
                Tools::log()->warning('duplicated-request');
                return true;
            }

            $code = $this->request->get('code');
            if ($action === 'nextcloud-preview') {
                $preview = NextcloudImportHelper::previewForModel(
                    $this->getModelClassName(),
                    $code,
                    $this->user
                );
                if (isset($this->views['docfiles'])) {
                    $this->views['docfiles']->settings['nextcloudPreview'] = $preview;
                }
                return true;
            }

            $selected = $this->request->request->get('nextcloud_files', []);
            if (!is_array($selected)) {
                $selected = [$selected];
            }
            $summary = NextcloudImportHelper::importForModel(
                $this->getModelClassName(),
                $code,
                $this->user,
                $selected
            );

            $folderInfo = $summary['folder'] !== '' ? ' (' . $summary['folder'] . ')' : '';
            Tools::log()->notice(sprintf(
                'Importación Nextcloud%s: %d añadidos, %d omitidos, %d errores.',
                $folderInfo,
                $summary['imported'],
                $summary['skipped'],
                $summary['errors']
            ));

            return true;
        };
    }

    public function loadData(): Closure
    {
        return function ($viewName, $view) {
            AssetManager::addJs(FS_ROUTE . '/Plugins/NextCloud/Assets/JS/nextcloud-folder-selector.js');

            $column = $view->columnForName('nextcloud-folder');
            if (null === $column || $column->widget->getType() !== 'select') {
                return;
            }

            $folders = NextcloudFolderHelper::listRootFolders($this->user);
            $current = trim((string)($view->model->nextcloud_folder ?? ''));
            if ($current !== '' && !isset($folders[$current])) {
                $folders[$current] = $current;
            }
            $column->widget->setValuesFromArray($folders, false, true);
        };
    }
}
